PACKAGE intpack IS
  TYPE bus_stat_vec IS ARRAY(0 to 7) OF INTEGER;
  TYPE bus_stat_t IS
    RECORD
      bus_val: bus_stat_vec;
      average_val : INTEGER;
    END RECORD;

  PROCEDURE bus_average( x : inout bus_stat_t );

END intpack;

PACKAGE BODY intpack IS
  PROCEDURE bus_average( x : inout bus_stat_t ) IS
    VARIABLE total : INTEGER := 0;
  BEGIN
    FOR i IN 0 TO 7 LOOP
      total := total + x.bus_val(i);
    END LOOP;
    x.average_val := total / 8;
  END bus_average;
END intpack;

-------------------------------------------------------------
-- added to make below compile
-------------------------------------------------------------
use work.intpack.all;
entity test3 is
end test3;
architecture behave of test3 is
  signal mem_update : bit;
  signal average : integer;
begin
-------------------------------------------------------------
PROCESS( mem_update )
  VARIABLE bus_statistics : bus_stat_t;
BEGIN
  bus_statistics.bus_val :=
    (50, 40, 30, 35, 45, 55, 65, 85 );

  bus_average(bus_statistics);
  average <= bus_statistics.average_val;

END PROCESS;
-------------------------------------------------------------
end behave;
-------------------------------------------------------------

